/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.entities.projectile;

import com.renyigesai.immortalers_delight.ImmortalersDelightMod;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightEntities;
import com.renyigesai.immortalers_delight.potion.immortaleffects.StunEffect;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SurveyorFang
extends Entity
implements TraceableEntity {
    public static final int ATTACK_DURATION = 20;
    public static final int LIFE_OFFSET = 2;
    public static final int ATTACK_TRIGGER_TICKS = 14;
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.m_135353_(SurveyorFang.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(SurveyorFang.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 24;
    private boolean clientSideAttackStarted;
    private boolean hasSpawnParticle;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private float dropChance = 0.0f;

    public SurveyorFang(EntityType<? extends SurveyorFang> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SurveyorFang(Level pLevel, double pX, double pY, double pZ, float pYRot, int pWarmupDelay, float damage, LivingEntity pOwner) {
        this((EntityType<? extends SurveyorFang>)((EntityType)ImmortalersDelightEntities.SURVEYOR_FANG.get()), pLevel);
        this.warmupDelayTicks = pWarmupDelay;
        this.setOwner(pOwner);
        this.setDamage(damage);
        this.m_146922_(pYRot * 57.295776f);
        this.m_6034_(pX, pY, pZ);
    }

    public SurveyorFang(Level pLevel, double pX, double pY, double pZ, float pYRot, int pWarmupDelay, float damage, ItemStack itemStack, LivingEntity pOwner) {
        this((EntityType<? extends SurveyorFang>)((EntityType)ImmortalersDelightEntities.SURVEYOR_FANG.get()), pLevel);
        this.warmupDelayTicks = pWarmupDelay;
        this.setOwner(pOwner);
        this.setDamage(damage);
        this.setItem(itemStack);
        this.m_146922_(pYRot * 57.295776f);
        this.m_6034_(pX, pY, pZ);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(DATA_ITEM, (Object)ItemStack.f_41583_);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public void setItem(ItemStack pStack) {
        if (!pStack.m_41619_()) {
            pStack = pStack.m_255036_(1);
        }
        this.m_20088_().m_135381_(DATA_ITEM, (Object)pStack);
    }

    public ItemStack getItem() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM);
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_7378_(CompoundTag pCompound) {
        CompoundTag compoundtag = pCompound.m_128469_("Item");
        if (compoundtag != null && !compoundtag.m_128456_()) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
            if (itemstack.m_41619_()) {
                ImmortalersDelightMod.LOGGER.warn("Unable to load item from: {}", (Object)compoundtag);
            }
            this.setItem(itemstack);
            if (pCompound.m_128425_("ItemDropChance", 99)) {
                this.dropChance = pCompound.m_128457_("ItemDropChance");
            }
        }
        this.warmupDelayTicks = pCompound.m_128451_("Warmup");
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
        this.setDamage(pCompound.m_128457_("damage"));
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
        pCompound.m_128350_("damage", this.getDamage());
        pCompound.m_128365_("Item", (Tag)this.getItem().m_41739_(new CompoundTag()));
        pCompound.m_128350_("ItemDropChance", this.dropChance);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                double d2;
                double d1;
                double d0;
                SimpleParticleType type;
                if (!this.hasSpawnParticle) {
                    this.hasSpawnParticle = true;
                    for (int j = 0; j < 32; ++j) {
                        type = j % 4 == 0 ? ParticleTypes.f_123771_ : ParticleTypes.f_123760_;
                        d0 = j >= 20 ? (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3 : 0.0;
                        d1 = j >= 20 ? 0.3 + this.f_19796_.m_188500_() * 0.3 : 0.0;
                        d2 = j >= 20 ? (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3 : 0.0;
                        this.m_9236_().m_7106_((ParticleOptions)type, this.f_19854_, this.m_20187_() + this.f_19796_.m_188500_() * 2.0, this.f_19856_, d0, d1, d2);
                    }
                }
                --this.lifeTicks;
                if (this.lifeTicks == 12) {
                    for (int i = 0; i < 32; ++i) {
                        type = i >= 12 ? ParticleTypes.f_123811_ : ParticleTypes.f_123797_;
                        d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        d1 = this.m_20186_() + 0.05 + this.f_19796_.m_188500_();
                        d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d3 = i >= 12 ? 0.4 : (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        double d4 = i >= 12 ? 0.3 : 0.3 + this.f_19796_.m_188500_() * 0.3;
                        double d5 = i >= 12 ? 0.35 : (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        this.m_9236_().m_7106_((ParticleOptions)type, d0, d1 + 1.0, d2, d3, d4, d5);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -12) {
                AABB aabb = this.m_20191_().m_82400_(0.3);
                AABB selection = new AABB(aabb.f_82288_, this.m_20186_() - 0.6, aabb.f_82290_, aabb.f_82291_, this.m_20186_() + 3.5, aabb.f_82293_);
                for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, selection)) {
                    this.dealDamageTo(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    private void dealDamageTo(LivingEntity pTarget) {
        LivingEntity livingentity = this.getOwner();
        float damage = this.getDamage();
        if (damage <= 0.0f) {
            damage = 6.0f;
        }
        if (pTarget.m_6084_() && !pTarget.m_20147_() && pTarget != livingentity) {
            if (livingentity == null) {
                pTarget.m_6469_(this.m_269291_().m_269325_(), damage);
                pTarget.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 110, 1));
                StunEffect.applyImmortalEffect(pTarget, 20, 0);
                pTarget.f_19802_ = 0;
                pTarget.m_6469_(this.m_269291_().m_269425_(), 3.0f);
            } else {
                if (livingentity.m_7307_((Entity)pTarget)) {
                    return;
                }
                pTarget.m_6469_(this.m_269291_().m_269299_((Entity)this, livingentity), this.getDamage());
                pTarget.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 110, 1));
                StunEffect.applyImmortalEffect(pTarget, 20, 0);
                pTarget.f_19802_ = 0;
                pTarget.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), 3.0f);
            }
        }
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        if (pId == 4) {
            this.clientSideAttackStarted = true;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12057_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        }
    }

    public float getAnimationProgress(float pPartialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - pPartialTicks) / 20.0f;
    }
}

